/* -*-C-*-
 ##############################################################################
 #
 # File:        trice/src/saverec.c 
 # RCS:         "@(#)$Revision: 1.15 $ $Date: 94/03/09 11:12:39 $"
 # Description: User routines for saving and recalling state of a E1430 module.
 # Author:      Doug Passey
 # Created:     
 # Language:    C
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 #
 # Revisions:
 #
 ##############################################################################
*/

#    include <stdio.h>

#include "trice.h"
#include "err1430.h"

#ifndef lint
const char i1430_save_fileId[] = "$Header: saverec.c,v 1.15 94/03/09 11:12:39 chriss Exp $";
#endif

/* magic numbers a beginning of state files to distinquish revision */
#define MAGIC_REV_1		0xFAB0DAB1


/*****************************************************************************
 * 
 * Restore a module at logical address, <la>, to the state pointed to by
 * <imagePtr>.
 *
 * Returns negative error number if error, otherwise returns 0.
 ****************************************************************************/
SHORTSIZ16 i1430_restore_state_la(SHORTSIZ16 la, aModuleImage DOS_FAR *image)
{

  SHORTSIZ16 index, i;
  SHORTSIZ16 error;

  /* do the timing register first in case synchronous group */
  error = e1430_write_register_image(la, E1430_TIMING_SETUP_REG, image->timingSetup);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ANALOG_SETUP_REG, image->analogSetup);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_MEAS_CONTROL_REG, image->measControl);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_INPUT_OFFSET_REG, image->offset);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_DATA_FORMAT_REG, image->dataFormat);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_IRQ_CONFIG_0_REG, image->irqConfig0);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_IRQ_CONFIG_1_REG, image->irqConfig1);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_HP_PORT_CONTROL_REG, 
							image->portControl);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_TRIGGER_SETUP_REG, image->trigSetup);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_TRIGGER_BLOCKSIZE_REG, 	
						image->trigBlocksize);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_TRIGGER_OFFSET_LO_REG, 
						image->trigOffset);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_TRIGGER_PASSOUT_REG, 
						image->trigPassout);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ADC_CONTROL_REG, image->adcControl);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_PHASE_0_REG, image->zoomPhase0);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_PHASE_1_REG, image->zoomPhase1);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_INTERP_0_REG, image->zoomInterp0);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_INTERP_1_REG, image->zoomInterp1);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_INTERP_2_REG, image->zoomInterp2);
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_INTERP_3_REG, image->zoomInterp3);
  if(error) return(error);

  /* setup transfer of center frequency */
/*  error = e1430_write_register_image(la, E1430_ZOOM_CONTROL_REG, 14); */
  error = e1430_write_register_image(la, E1430_ZOOM_CONTROL_REG, 1); 
  if(error) return(error);

  /* transfer center frequency */
  error = e1430_write_register_card(la, E1430_LO_TRANSFER_REG, 0); 
  if(error) return(error);

  error = e1430_write_register_image(la, E1430_ZOOM_CONTROL_REG, image->zoomControl);
  if(error) return(error);

  error = i1430_get_index_from_la(la, &index);
  if(error) return(error);

  e1430_modStates[index].trigLevelSave = image->trigLevelSave;
  
  e1430_modStates[index].trigSlopeSave = image->trigSlopeSave;

  e1430_modStates[index].trigDelaySave = image->trigDelaySave;

  for(i=0; i<RANGE_STEPS; i++) {
    e1430_modStates[index].offsetSave[i] = image->offsetSave[i];
  }

  e1430_modStates[index].sampleFreq = image->sampleFreq;

  return (0);
}

